/// ***********************************************************************************
/// Developer & Platformgruppe Austria
/// Author: Andreas Pollak
///===============================================================================
/// Copyright  Microsoft Corporation.  All rights reserved.
/// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
/// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
/// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
/// FITNESS FOR A PARTICULAR PURPOSE.
///===============================================================================
/// The example companies, organizations, products, domain names,
/// e-mail addresses, logos, people, places, and events depicted
/// herein are fictitious.  No association with any real company,
/// organization, product, domain name, email address, logo, person,
/// places, or events is intended or should be inferred.
///===============================================================================
/// Before implementing this on your website read the licensing terms of Virtual Earth:
/// http://www.microsoft.com/virtualearth/control/terms.mspx
/// ***********************************************************************************
var Error_ShopAdressMorePrecisely = "Please define your shopadress more precisly.";
var myShopName        = "Schlossresidenz";
var myShopDescription = "<a href='http://www.schlossresidenz.com'>www.schlossresidenz.com</a><br><img src='http://www.schlossresidenz.com/ShopFinder/Images/PushPin.gif' />  ";
var myShopAddress     = "Schlossstrasse 15,49074 Osnabrck, Germany";               
var myShopPushPinImage= "http://www.schlossresidenz.com/ShopFinder/Images/PushPin.gif";
var myResultPrefix    = "<B>Ihre Route</B>: <br />";
var myResultTotalDistancePrefix = "Total dis1undtance: ";
var myZoomLevel       = 18;
var myRouteListBoxHeight = 14;

var control_FocusButton = "pbFocusShop";
var control_txtStreet   = "txtStreet";
var control_txtHouseNr  = "txtHouseNr";
var control_txtPLZ      = "txtPLZ";
var control_txtCity     = "txtCity";
var control_divMap      = "myMap";
var control_divResult   = "divRouteResult";

// Internal Member Variables
var myMap = null;   
var myShopVerResult = null;
var myLastRouteSegments = null;
var control_listBoxID   = "lstlstRoute";

///===============================================================================
/// This function initializes the VE-Map control and locates the shop
/// using the address that is provided in the myShopAddress variable.
/// Author: Andreas Pollak, Microsoft sterreich GesmbH
///===============================================================================
function InitMap()         
{            
  myMap = new VEMap(control_divMap);            
  myMap.LoadMap();       
  //Seek the Shopadress and call the callback OnFoundShopAddress when done
  myMap.FindLocation(myShopAddress,OnFoundShopAddress);
}
  
///===============================================================================
/// This function will be called back by the VE-Control. The Callback is set
/// in the InitMap() method.
/// If multiple locations are found the address is not specific enough. In this
/// case we alert an error. If the adress is specific enough we add a pushpin
/// with following informations:
///		myShopPushPinImage...	URL to the Image of the Pushpin
///     myShopName...			Name of the Pushpin
///     myShopDescription...	Description of the Shop/Restaurant,... in HTML
/// Author: Andreas Pollak, Microsoft sterreich GesmbH
///===============================================================================
function OnFoundShopAddress(e)
{
    if (e.Length>0) { alert(Error_ShopAdressMorePrecisely); return;}
    myShopVerResult=e[0];
    var pin = new VEPushpin(1,
                            myShopVerResult.LatLong,
                            myShopPushPinImage,
                            myShopName,
                            myShopDescription);
    myMap.AddPushpin(pin);
}

///===============================================================================
/// This function refocuses the map on the shop-pushpin.
/// Author: Andreas Pollak, Microsoft sterreich GesmbH
///===============================================================================
function FocusShop()
{
    myMap.SetCenter(myShopVerResult.LatLong);
    myMap.SetZoomLevel(myZoomLevel);
}
 
///===============================================================================
/// This function is called by button "GetRoute" on the webpage. It will retrieve
/// the starting address that the customer entered and pass the information to the
/// GetRoute-Function that will calculate the route to the shop.
/// Author: Andreas Pollak, Microsoft sterreich GesmbH
///===============================================================================
function FindShop()
{
  var txtStreet=document.getElementById(control_txtStreet);
  var txtHouseNr=document.getElementById(control_txtHouseNr);
  var txtPLZ=document.getElementById(control_txtPLZ);
  var txtCity=document.getElementById(control_txtCity);
  /// We always assume that the shop is located in Austria
  GetRoute(txtStreet.value,txtHouseNr.value,txtPLZ.value,txtCity.value,'Austria');
}

///===============================================================================
/// Builds the address string from the provided parameters and requests the route
/// from Virutal Earth. If the route has loaded the function "OnGotRoute" is called.
/// Author: Andreas Pollak, Microsoft sterreich GesmbH
///===============================================================================
function GetRoute(street, housenr , plz, ort, country)
{
  var result = street + " " + housenr + ", "+plz+" "+ort+", "+country; 
  myMap.GetRoute(result, myShopAddress,VEDistanceUnit.Kilometers,VERouteType.Quickest,OnGotRoute); 
}

///===============================================================================
/// This method gets called by the VE-Control after the route has been calculated.
/// This method retrieves the segments from the result stores it in a membervariable
/// myLastRouteSegments  and shows the routesegments in a listbox in the DIV that is provided.
/// Each segment is associated with an ID 
/// Author: Andreas Pollak, Microsoft sterreich GesmbH
///===============================================================================
function OnGotRoute(route)
{
    // Total 
    //route.Itinerary.Distance 
    //route.Itinerary.DistanceUnit
    var myResultDIV = document.getElementById(control_divResult);
    var result = myResultPrefix+'<select id="'+control_listBoxID+'" onchange="javascript:OnClickRouteSegment();" size="'+
                                  myRouteListBoxHeight +'" style="width: 100%">';
        result+='<option value="-1">' + myResultTotalDistancePrefix + route.Itinerary.Distance+' '+route.Itinerary.DistanceUnit+'</option>';
    
    var steps="";     
    myLastRouteSegments = route.Itinerary.Segments;       
    var len = route.Itinerary.Segments.length;               
    for(var i = 0; i < len ;i++)               
    {
       result+='<option value="'+i+'">'+route.Itinerary.Segments[i].Instruction+' ('+
                       route.Itinerary.Segments[i].Distance+' '+
                       route.Itinerary.DistanceUnit+')</option>';                  
    }            
    result+='</select>';
    myResultDIV.innerHTML = result; 
}      

///===============================================================================
/// This method is called from the generated listbox. It will retrieve the current
/// selected value and focus on the route segment by calling the FocusSegment-
/// method.
/// Author: Andreas Pollak, Microsoft sterreich GesmbH
///===============================================================================
function OnClickRouteSegment()
{ 
    FocusSegment(document.getElementById(control_listBoxID).value);
}

///===============================================================================
/// This method uses the variable myLastRouteSegements that contains the
/// segments of the last calculated route (which is shown in the listbox) to
/// set the center of the map to the selected segment.
/// Author: Andreas Pollak, Microsoft sterreich GesmbH
///===============================================================================
function FocusSegment(i)
{
    if (i==-1) return;
    if (myLastRouteSegments==null) return;
    myMap.SetCenter(myLastRouteSegments[i].LatLong);
}

